
import os
import random
import subprocess


# Number of instances to create
NUM_INSTANCES = 51

# Make sure the output directory exists
os.makedirs("instances", exist_ok=True)

for i in range(NUM_INSTANCES):
    # Pick a random grid size between n and m (inclusive)
    grid_size = random.choice([4, 6])

    # Construct a seed for reproducibility; here, just use i
    seed = i

    # Build the command line to run the Tetris generator
    #   1) the generator script (replace with your actual script name/path)
    #   2) the random grid size
    #   3) the block type = 4 (mixed)
    #   4) our chosen seed
    # Then redirect (>) the output to a file instance-i.pddl
    command = (
        f"python generator.py {grid_size} 4 {seed} "
        f"> instances/instance-{i}.pddl"
    )

    print(f"Generating instance {i} with grid size {grid_size} (seed={seed})...")
    subprocess.run(command, shell=True, check=True)

print("All instances generated in the 'instances/' folder.")
